//
//  Calculator.m
//  TDD Example
//
//  Created by Dennis Lewandowski on 3/14/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "Calculator.h"

@interface Calculator(private)
-(void)remoteAdd:(int)a to:(int)b;
@end


# pragma mark -

@implementation Calculator

@synthesize delegate;


# pragma mark -
# pragma mark Synchronous methods

-(int)add:(int)numberOne to:(int)numberTwo
{
	int result = numberOne + numberTwo;
	
	return result;
}


# pragma mark -
# pragma mark Asynchronous methods

-(void)cloudAdd:(int)numberOne to:(int)numberTwo
{
    // create an invocation for the remoteAdd:to: method which will be excecuted asynchronous
	NSMethodSignature* calculationSignature = [Calculator instanceMethodSignatureForSelector:@selector(remoteAdd:to:)];
	NSInvocation *calculatorInvocation = [NSInvocation invocationWithMethodSignature:calculationSignature];
	
    // configure the invocation
	[calculatorInvocation setTarget:self];
	[calculatorInvocation setSelector:@selector(remoteAdd:to:)];
	[calculatorInvocation setArgument:&numberOne atIndex:2];
	[calculatorInvocation setArgument:&numberTwo atIndex:3];
	
    // create a timer to trigger the invocation after 0.5 seconds
	[NSTimer scheduledTimerWithTimeInterval:0.5 invocation:calculatorInvocation repeats:NO];
}

-(void)remoteAdd:(int)a to:(int)b
{
    // calculate the result and hand it over to the delegate
	int result = a + b;
	[delegate calculator:self didFinishWithResult:result];
}


@end
